% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-sibling}
\alias{node-sibling}
\alias{node_next_sibling}
\alias{node_next_named_sibling}
\alias{node_previous_sibling}
\alias{node_previous_named_sibling}
\title{Node sibling accessors}
\usage{
node_next_sibling(x)

node_next_named_sibling(x)

node_previous_sibling(x)

node_previous_named_sibling(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A sibling node, or \code{NULL} if there is no sibling node.
}
\description{
These functions return siblings of the current node, i.e. if you looked
"left" or "right" from the current node rather "up" (parent) or "down"
(child).
\itemize{
\item \code{node_next_sibling()} and \code{node_next_named_sibling()} return the next
sibling.
\item \code{node_previous_sibling()} and \code{node_previous_named_sibling()} return the
previous sibling.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Navigate to first child
node <- node_child(node, 1)

# Navigate to function definition node
node <- node_child(node, 3)
node

node_previous_sibling(node)

# Skip anonymous operator node
node_previous_named_sibling(node)

# There isn't one!
node_next_sibling(node)
\dontshow{\}) # examplesIf}
}
