% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forcats-like.R
\name{rename_reorder_factor}
\alias{rename_reorder_factor}
\title{Rename and reorder a factor.}
\usage{
rename_reorder_factor(.f, value_label_dict, reorder_vector,
  reorder_by_value_label_dict = T)
}
\arguments{
\item{.f}{A factor or vector (if .f is not yet a factor, it is made one)}

\item{value_label_dict}{a dictionary (named list or vector) of old->new factor levels}

\item{reorder_vector}{vector of factor levels (the new levels according to value_label_dict).
It need not contain all levels, only those found will be reorderer first}

\item{reorder_by_value_label_dict}{Should the factor also be reordered following the order of value_label_dict?}
}
\value{
A renamed and reordered factor
}
\description{
The factor will be recoded according to value_label_dict and, if requested,
also reordered by the order of this vector.
Secondly, the vector will be reordered according to reorder_vector, if given.
}
\seealso{
\code{\link{rename_factor}}, \code{\link{order_factor_by}},
   \code{forcats::\link{fct_recode}}, \code{forcats::\link{fct_relevel}}
}
