\name{MLR}
\alias{MLR}
\title{Multiple Linear Regression}
\description{
Multiple linear regression approach on summary statistics
}
\usage{
MLR(scoreFile, geneFile, regions, cor.path = "", annoType = "",
n, write.file = FALSE)
}

\arguments{
	\item{scoreFile}{name of data file generated by \code{prep.score.files()}.}

	\item{geneFile}{name of a text file listing genes in refFlat format. If not set, hg19 file
	will be used (see Examples below).}

	\item{regions}{character vector of gene names to be analysed. If not set, function will
	attempt to analyse all genes listed in \code{geneFile}.}

	\item{cor.path}{path to a folder with correlation files (one file per each gene to be analysed).
	Names of correlation files should be constructed as "geneName.cor" (e.g. "ABCG1.cor", "ADAMTS1.cor", etc.)
	Each file should contain a square matrix with correlation coefficients (r) between genetic variants
	of a gene. An example of correlation file format:\cr
	"snpname1" "snpname2" "snpname3" ...\cr
	"snpname1" 1 0.018 -0.003 ...\cr
	"snpname2" 0.018 1 0.081 ...\cr
	"snpname3" -0.003 0.081 1 ...\cr
	...\cr
	One way to generate such file from original genotypes is:\cr
	\code{write.table(cor(g), file = paste0(geneName, ".cor"))}\cr
	where \code{g} is a genotype matrix (nsample x nvariants) for a given gene with genotypes coded as 0, 1, 2
	(exactly the same coding that was used to generate betas).
	}

	\item{annoType}{for files annotated with the \code{seqminer} package, a character (or character vector) indicating annotation types to be used (e.g. 
	"Nonsynonymous", "Start_Loss", "Stop_loss", "Essential_Splice_Site")}

	\item{n}{size of the sample on which summary statitics were obtained.}

	\item{write.file}{output file name to write results as they come (sequential mode only).}

	\item{...}{other arguments that could be passed to \code{null()}, \code{read.plink()}\cr
	and \code{readVCFToMatrixByGene()}.}
}
\value{
	A data frame containing P values, numbers of variants and filtered variants for each of analyzed regions.
}
\examples{

## Run MLR with example files:
VCFfileName <- system.file("testfiles/CFH.scores.anno.vcf.gz",
	package = "sumFREGAT")
cor.path <- system.file("testfiles/", package = "sumFREGAT")
n <- 85 # your sample size
out <- MLR(VCFfileName, region = 'CFH', cor.path = cor.path, n = n)

}
