% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tmap.R
\name{choropleth_tmap}
\alias{choropleth_tmap}
\title{Map object of class sf using tmap}
\usage{
choropleth_tmap(sf_object, value = "output", id_name = "id",
  mode = "plot", legend_title = "Clustering", palette = "viridis")
}
\arguments{
\item{sf_object}{object of class sf}

\item{value}{column name to shade the polygons}

\item{id_name}{column name of ids to plot}

\item{mode}{choose between static ('plot' is default) and interactive map ('view')}

\item{legend_title}{title of legend}

\item{palette}{palette name or a vector of colors. See tmaptools::palette_explorer() for the named palettes. Use a "-" as prefix to reverse the palette. The default palette is "viridis".}
}
\value{
ggplot map
}
\description{
Takes an object produced by \code{choropleth_sf()}, and creates the correspoding choropleth map.
}
\examples{
test <- choropleth_sf(nl_provincie, insurance, sum(amount, na.rm = TRUE))
choropleth_tmap(test)
choropleth_tmap(test, id_name = "province_name", mode = "view")
}
\author{
Martin Haringa
}
