% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_evaluation.R
\name{plot_evaluation}
\alias{plot_evaluation}
\title{Plots the results of a spatial cross-validation}
\usage{
plot_evaluation(
  model,
  fill.color = viridis::viridis(
    3,
    option = "F",
    alpha = 0.8,
    direction = -1
    ),
  line.color = "gray30",
  verbose = TRUE,
  notch = TRUE
)
}
\arguments{
\item{model}{A model resulting from \code{\link[=rf_evaluate]{rf_evaluate()}}.}

\item{fill.color}{Character vector with three hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(3)}). Default: \code{viridis::viridis(3, option = "F", alpha = 0.8, direction = -1)}}

\item{line.color}{Character string, color of the line produced by \code{ggplot2::geom_smooth()}. Default: \code{"gray30"}}

\item{verbose}{Logical, if \code{TRUE} the plot is printed. Default: \code{TRUE}}

\item{notch}{Logical, if \code{TRUE}, boxplot notches are plotted. Default: \code{TRUE}}
}
\value{
A ggplot.
}
\description{
Plots the results of an spatial cross-validation performed with \code{\link[=rf_evaluate]{rf_evaluate()}}.
}
\examples{
if(interactive()){

#loading example data
data(plant_richness_df)
data(distance_matrix)

#fitting a random forest model
rf.model <- rf(
  data = plant_richness_df,
  dependent.variable.name = "richness_species_vascular",
  predictor.variable.names = colnames(plant_richness_df)[5:21],
  distance.matrix = distance_matrix,
  distance.thresholds = 0,
  n.cores = 1,
  verbose = FALSE
)

#evaluating the model with spatial cross-validation
rf.model <- rf_evaluate(
  model = rf.model,
  xy = plant_richness_df[, c("x", "y")],
  n.cores = 1
)

#plotting the evaluation results
plot_evaluation(rf.model)

}

}
\seealso{
\code{\link[=rf_evaluate]{rf_evaluate()}}, \code{\link[=get_evaluation]{get_evaluation()}}, \code{\link[=print_evaluation]{print_evaluation()}}.
}
