/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.File;
import java.io.FileWriter;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;
import scala.util.Random$;
import sparklyr.Backend;
import sparklyr.JVMObjectTracker;
import sparklyr.Logger;
import sparklyr.Rscript;
import sparklyr.Sources;
import sparklyr.WorkerContext;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000b\tYqk\u001c:lKJ\f\u0005\u000f\u001d7z\u0015\u0005\u0019\u0011\u0001C:qCJ\\G.\u001f:\u0004\u0001M\u0011\u0001A\u0002\t\u0003\u000f)i\u0011\u0001\u0003\u0006\u0002\u0013\u0005)1oY1mC&\u00111\u0002\u0003\u0002\u0007\u0003:L(+\u001a4\t\u00115\u0001!\u0011!Q\u0001\n9\tqa\u00197pgV\u0014X\rE\u0002\b\u001fEI!\u0001\u0005\u0005\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001d\u0011\u0012BA\n\t\u0005\u0011\u0011\u0015\u0010^3\t\u0011U\u0001!\u0011!Q\u0001\nY\tqaY8mk6t7\u000fE\u0002\b\u001f]\u0001\"\u0001G\u000e\u000f\u0005\u001dI\u0012B\u0001\u000e\t\u0003\u0019\u0001&/\u001a3fM&\u0011A$\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iA\u0001\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\r\r|gNZ5h\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013\u0001\u00029peR\u0004\"aB\u0012\n\u0005\u0011B!aA%oi\"Aa\u0005\u0001B\u0001B\u0003%a#A\u0004he>,\bOQ=\t\u0011!\u0002!\u0011!Q\u0001\n9\tAb\u00197pgV\u0014XM\u0015'b]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000bEVtG\r\\3QCRD\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0013\r,8\u000f^8n\u000b:4\b\u0003\u0002\r//]I!aL\u000f\u0003\u00075\u000b\u0007\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u0003#\u0003E\u0019wN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0005\tg\u0001\u0011\t\u0011)A\u0005\u001d\u000591m\u001c8uKb$\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u000f=\u0004H/[8og\")q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"B\"O\u001e={yz\u0004)\u0011\"D\t\u0016\u0003\"A\u000f\u0001\u000e\u0003\tAQ!\u0004\u001cA\u00029AQ!\u0006\u001cA\u0002YAQa\b\u001cA\u0002]AQ!\t\u001cA\u0002\tBQA\n\u001cA\u0002YAQ\u0001\u000b\u001cA\u00029AQA\u000b\u001cA\u0002]AQ\u0001\f\u001cA\u00025BQ!\r\u001cA\u0002\tBQa\r\u001cA\u00029AQ!\u000e\u001cA\u00025Baa\u0012\u0001!B\u0013A\u0015!C3yG\u0016\u0004H/[8o!\r9\u0011jS\u0005\u0003\u0015\"\u0011aa\u00149uS>t\u0007C\u0001'U\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002Q\t\u00051AH]8pizJ\u0011!C\u0005\u0003'\"\tq\u0001]1dW\u0006<W-\u0003\u0002V-\nIQ\t_2faRLwN\u001c\u0006\u0003'\"Aa\u0001\u0017\u0001!B\u0013\u0011\u0013a\u00032bG.,g\u000e\u001a)peRDQA\u0017\u0001\u0005\u0002m\u000b\u0001c^8sW\u0016\u00148k\\;sG\u00164\u0015\u000e\\3\u0015\u0005]a\u0006\"B/Z\u0001\u0004q\u0016a\u0002:tGJL\u0007\u000f\u001e\t\u0003u}K!\u0001\u0019\u0002\u0003\u000fI\u001b8M]5qi\")!\r\u0001C\u0001G\u0006)\u0011\r\u001d9msR\u0011Am\u001d\t\u0004\u0019\u0016<\u0017B\u00014W\u0005!IE/\u001a:bi>\u0014\bC\u00015r\u001b\u0005I'B\u00016l\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y6\fQa\u001d9be.T!A\\8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0018aA8sO&\u0011!/\u001b\u0002\u0004%><\b\"\u0002;b\u0001\u0004!\u0017\u0001C5uKJ\fGo\u001c:")
public class WorkerApply {
    private final byte[] closure;
    private final String[] columns;
    public final String sparklyr$WorkerApply$$config;
    private final int port;
    private final String[] groupBy;
    private final byte[] closureRLang;
    private final String bundlePath;
    public final Map<String, String> sparklyr$WorkerApply$$customEnv;
    private final int connectionTimeout;
    private final byte[] context;
    public final Map<String, String> sparklyr$WorkerApply$$options;
    public Option<Exception> sparklyr$WorkerApply$$exception;
    public int sparklyr$WorkerApply$$backendPort;

    public String workerSourceFile(Rscript rscript) {
        Sources rsources = new Sources();
        String source = rsources.sources();
        File tempFile = new File(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)rscript.getScratchDir()), File.separator)).append((Object)"sparkworker.R").toString());
        FileWriter outStream = new FileWriter(tempFile);
        outStream.write(source);
        outStream.flush();
        return tempFile.getAbsolutePath();
    }

    public Iterator<Row> apply(Iterator<Row> iterator) {
        int sessionId = Random$.MODULE$.nextInt(10000);
        Logger logger = new Logger("Worker", sessionId);
        Object lock = new Object();
        Row[] data = (Row[])iterator.toArray(ClassTag$.MODULE$.apply(Row.class));
        if (data.length == 0) {
            return Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Row.class))).iterator();
        }
        WorkerContext workerContext = new WorkerContext(data, lock, this.closure, this.columns, this.groupBy, this.closureRLang, this.bundlePath, this.context);
        JVMObjectTracker tracker = new JVMObjectTracker();
        String contextId = tracker.put(workerContext);
        logger.log(new StringBuilder().append((Object)"is tracking worker context under ").append((Object)contextId).toString());
        logger.log("initializing backend");
        Backend backend = new Backend();
        backend.setTracker(tracker);
        backend.setType(true, false, true, false);
        backend.setHostContext(contextId);
        backend.init(this.port, sessionId, this.connectionTimeout);
        this.sparklyr$WorkerApply$$backendPort = backend.getPort();
        new Thread(this, logger, lock, backend){
            private final /* synthetic */ WorkerApply $outer;
            private final Logger logger$1;
            private final Object lock$1;
            private final Backend backend$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    this.logger$1.log("starting backend");
                    this.backend$1.run();
                    return;
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed while running backend: ", exception);
                    this.$outer.sparklyr$WorkerApply$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                        return;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.logger$1 = logger$1;
                this.lock$1 = lock$1;
                this.backend$1 = backend$1;
                super("starting backend thread");
            }
        }.start();
        new Thread(this, sessionId, logger, lock){
            private final /* synthetic */ WorkerApply $outer;
            private final int sessionId$1;
            private final Logger logger$1;
            private final Object lock$1;

            public void run() {
                try {
                    this.logger$1.log("is starting rscript");
                    Rscript rscript = new Rscript(this.logger$1);
                    String sourceFilePath = this.$outer.workerSourceFile(rscript);
                    rscript.init((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)this.sessionId$1)).toString(), ((Object)BoxesRunTime.boxToInteger((int)this.$outer.sparklyr$WorkerApply$$backendPort)).toString(), this.$outer.sparklyr$WorkerApply$$config})), sourceFilePath, this.$outer.sparklyr$WorkerApply$$customEnv, this.$outer.sparklyr$WorkerApply$$options);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed to run rscript: ", exception);
                    this.$outer.sparklyr$WorkerApply$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sessionId$1 = sessionId$1;
                this.logger$1 = logger$1;
                this.lock$1 = lock$1;
                super("starting rscript thread");
            }
        }.start();
        logger.log("is waiting using lock for RScript to complete");
        Object object = lock;
        synchronized (object) {
            lock.wait();
            // ** MonitorExit[lock] (shouldn't be in output)
            logger.log("completed wait using lock for RScript");
            if (this.sparklyr$WorkerApply$$exception.isDefined()) {
                throw (Throwable)this.sparklyr$WorkerApply$$exception.get();
            }
            logger.log(new StringBuilder().append((Object)"is returning RDD iterator with ").append((Object)BoxesRunTime.boxToInteger((int)workerContext.getResultArray().length)).append((Object)" rows").toString());
            return Predef$.MODULE$.refArrayOps((Object[])workerContext.getResultArray()).iterator();
        }
    }

    public WorkerApply(byte[] closure, String[] columns, String config, int port, String[] groupBy2, byte[] closureRLang, String bundlePath, Map<String, String> customEnv, int connectionTimeout, byte[] context, Map<String, String> options) {
        this.closure = closure;
        this.columns = columns;
        this.sparklyr$WorkerApply$$config = config;
        this.port = port;
        this.groupBy = groupBy2;
        this.closureRLang = closureRLang;
        this.bundlePath = bundlePath;
        this.sparklyr$WorkerApply$$customEnv = customEnv;
        this.connectionTimeout = connectionTimeout;
        this.context = context;
        this.sparklyr$WorkerApply$$options = options;
        this.sparklyr$WorkerApply$$exception = None$.MODULE$;
        this.sparklyr$WorkerApply$$backendPort = 0;
    }
}

