% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FisherTest.R
\name{render.sigr_fishertest}
\alias{render.sigr_fishertest}
\title{Format fisher.test (test of categorial indendence).}
\usage{
\method{render}{sigr_fishertest}(statistic, ..., format, statDigits = 2,
  sigDigits = 2, pLargeCutoff = 0.05, pSmallCutoff = 1e-05)
}
\arguments{
\item{statistic}{wrapped Fisher test}

\item{...}{extra arguments (not used)}

\item{format}{if set the format to return ("html", "latex", "markdown", "ascii", "docx", ...)}

\item{statDigits}{integer number of digits to show in summaries.}

\item{sigDigits}{integer number of digits to show in significances.}

\item{pLargeCutoff}{value to declare non-significance at or above.}

\item{pSmallCutoff}{smallest value to print}
}
\value{
formatted string and fields
}
\description{
Format fisher.test (test of categorial indendence).
}
\examples{

d <- data.frame(x=c('b','a','a','a','b','b','b'),
                y=c('1','1','1','2','2','2','2'))
ft <- fisher.test(table(d))
wrapFisherTest(ft)


}
