% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static.R
\name{httd}
\alias{httd}
\alias{httr}
\alias{httw}
\title{Serve static files under a directory}
\usage{
httd(dir = ".", ..., response = NULL)

httr(dir = ".", ...)

httw(
  dir = ".",
  watch = ".",
  pattern = NULL,
  all_files = FALSE,
  filter = NULL,
  handler = NULL,
  ...
)
}
\arguments{
\item{dir}{The root directory to serve.}

\item{...}{Server configurations passed to \code{\link{server_config}()}.}

\item{response}{A function of the form \code{function(path, res, ...)} that
takes a file path and server response as input, and return a new response.
This can be useful for post-processing the response (for experts only).}

\item{watch}{A directory under which \code{httw()} is to watch for changes.
If it is a relative path, it is relative to the \code{dir} argument.}

\item{pattern}{A regular expression passed to \code{\link{list.files}()} to
determine the files to watch.}

\item{all_files}{Whether to watch all files including the hidden files.}

\item{filter}{A function to filter the file paths returned from
\code{list.files()} (e.g., you can exclude certain files from the watch
list).}

\item{handler}{A function to be called every time any files are changed or
added under the directory; its argument is a character vector of the
filenames of the files modified or added.}
}
\description{
If there is an \file{index.html} under this directory, it will be displayed;
otherwise the list of files is displayed, with links on their names. After we
run this function, we can go to \samp{http://localhost:port} to browse the
web pages either created from R or read from HTML files.
}
\details{
\code{httd()} is a static file server by default (its \code{response}
argument can turn it into a dynamic file server).

\code{httr()} is based on \code{httr()} with a custom
  \code{response} function that executes R files via \code{xfun::record()},
  so that you will see the output of an R script as an HTML page. The page
  will be automatically updated when the R script is modified and saved.

\code{httw()} is similar to \code{httd()} but watches for changes
  under the directory: if an HTML file is being viewed in the browser, and
  any files are modified under the directory, the HTML page will be
  automatically refreshed.
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
servr::httd()
\dontshow{\}) # examplesIf}
}
\references{
\url{https://github.com/yihui/servr}
}
