% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAssignable.R
\name{GetDummifiable}
\alias{GetDummifiable}
\title{Dummifiable IDs}
\usage{
GetDummifiable(Pedigree, gID, minSibSize)
}
\arguments{
\item{Pedigree}{dataframe with id - dam - sire.}

\item{gID}{vector with IDs of SNP-genotyped individuals.}

\item{minSibSize}{minimum requirements to be considered dummifiable:
 \itemize{
    \item '1sib' : sibship of size 1, with or without grandparents. The
    latter aren't really a sibship, but can be useful in some situations.
    \item '1sib1GP': sibship of size 1 with at least 1 grandparent
    \item '2sib': at least 2 siblings, with or without grandparents. Used
       by \code{\link{PedCompare}}
}.}
}
\value{
A length-2 list (dams, sires) with each element a vector with
  dummifiable ids
}
\description{
Get the dummifiable individuals, using various possible
  criteria
}
\details{
values of minSibSize used by calling functions
  \describe{
    \item{1sib}{CalcOHLLR, CalcPairLL}
    \item{1sib1GP}{getAssignCat (default when user called)}
    \item{2sib}{PedCompare}
  }
}
\keyword{internal}
