% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semtree.control.R
\name{semtree.control}
\alias{semtree.control}
\alias{print.semtree.control}
\title{SEM Tree Control Object}
\usage{
semtree.control(
  method = c("naive", "score", "fair", "fair3"),
  min.N = 20,
  max.depth = NA,
  alpha = 0.05,
  alpha.invariance = NA,
  folds = 5,
  exclude.heywood = TRUE,
  progress.bar = TRUE,
  verbose = FALSE,
  bonferroni = FALSE,
  use.all = FALSE,
  seed = NA,
  custom.stopping.rule = NA,
  mtry = NA,
  report.level = 0,
  exclude.code = NA,
  linear = TRUE,
  min.bucket = 10,
  naive.bonferroni.type = 0,
  missing = "ignore",
  use.maxlm = FALSE,
  strucchange.from = 0.15,
  strucchange.to = NULL,
  strucchange.nrep = 50000,
  refit = TRUE,
  ctsem_sd = FALSE
)
}
\arguments{
\item{method}{Default: 'naive'. One out of
\code{c("score","fair","naive")} for either an unbiased two-step
selection algorithm,  a naive take-the-best, or a
score-based testing scheme.}

\item{min.N}{Default: 10. Minimum sample size per a node, used to determine
whether to continue splitting a tree or establish a terminal node.}

\item{max.depth}{Default: NA. Maximum levels per a branch. Parameter for
limiting tree growth.}

\item{alpha}{Default: 0.05. Significance level for splitting at a given
node.}

\item{alpha.invariance}{Default: NA. Significance level for invariance
tests. If NA, the value of alpha is used.}

\item{folds}{Default: 5. Defines the number of folds for the \code{"cv"}
method.}

\item{exclude.heywood}{Default: TRUE. Reports whether there is an
identification problem in the covariance structure of an SEM tested.}

\item{progress.bar}{Default: NA. Option to disable the progress bar for tree
growth.}

\item{verbose}{Default: FALSE. Option to turn on or off \emph{all} model
messages during tree growth.}

\item{bonferroni}{Default: FALSE. Correct for multiple tests with Bonferroni
type correction.}

\item{use.all}{Treatment of missing variables. By default, missing values
stay in a decision node. If TRUE, cases are distributed according to a
maximum likelihood principle to the child nodes.}

\item{seed}{Default: NA. Set a random number seed for repeating random fold
generation in tree analysis.}

\item{custom.stopping.rule}{Default: NA. Otherwise, this can be a boolean
function with a custom stopping rule for tree growing.}

\item{mtry}{Default: NA. Number of sample columns to use in SEMforest
analysis.}

\item{report.level}{Default: 0. Values up to 99 can be used to increase the
number of onscreen reports for semtree analysis.}

\item{exclude.code}{Default: NA. NPSOL error code for exclusion from model
fit evaluations when finding best split. Default: Models with errors during
fitting are retained.}

\item{linear}{If TRUE (default), the structural equation model is assumed to
not contain any nonlinear parameter constraints and scores are computed
analytically, resulting in a shorter runtime. Only relevant for models fitted
with OpenMx.}

\item{min.bucket}{Minimum bucket size. This is the minimum size any node
must have, such that a given split is considered valid. Minimum bucket size
is a lower bound to the sample size in the terminal nodes of a tree.}

\item{naive.bonferroni.type}{Default: 0. When set to zero, bonferroni
correction for the naive test counts the number of dichotomous tests. When
set to one, bonferroni correction counts the number of variables tested.}

\item{missing}{Missing value treatment. Default is ignore}

\item{use.maxlm}{Use MaxLR statistic for split point selection (as proposed by Arnold et al., 2021)}

\item{strucchange.from}{Strucchange argument. See their package
documentation.}

\item{strucchange.to}{Strucchange argument. See their package documentation.}

\item{strucchange.nrep}{Strucchange argument. See their package
documentation.}

\item{refit}{If TRUE (default) the initial model is fitted on the data
provided to \code{\link{semtree}}.}

\item{ctsem_sd}{If FALSE (default) no standard errors of CT model parameters
are computed. Requesting standard errors increases runtime.}
}
\value{
A control object containing a list of the above parameters.
}
\description{
A \code{semtree.control} object contains parameters that determine the tree
growing process. These parameters include choices of different split
candidate selection procedures and hyperparameters of those. Calling the
constructor without parameters creates a default control object. A number of
tree growing methods are included in with this package: 1. 'naive' splitting
takes the best split value of all possible splits on each covariate. 2.
'fair' selection is so called because it tests all splits on half of the
data, then tests the best split value for each covariate on the other half
of the data. The equal footing of each covariate in this two phase test
removes bias from testing variables with many possible splits compared to
those with few. 3. "fair3" does the phases described above, with an
additional step of retesting all of the split values on the best covariate
found in the second phase. Variations in the sample from subsetting are
removed and bias in split selection further reduced. 4. 'score'
implements modern score-based statistics.
}
\examples{


	# create a control object with an alpha level of 1\%
	my.control <- semtree.control(alpha=0.01)

	# set the minimum number of cases per node to ten
	my.control$min.N <- 10
	
	# print contents of the control object
	print(my.control)


}
\references{
Brandmaier, A.M., Oertzen, T. v., McArdle, J.J., & Lindenberger,
U. (2013). Structural equation model trees. \emph{Psychological Methods},
18(1), 71-86.

Arnold, M., Voelkle, M. C., & Brandmaier, A. M. (2021). Score-guided structural equation model trees. \emph{Frontiers in Psychology}, 11, Article 564403. https://doi.org/10.3389/fpsyg.2020.564403
}
\seealso{
\code{\link{semtree}}
}
\author{
Andreas M. Brandmaier, John J. Prindle, Manuel Arnold
}
