% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element.R
\name{ShadowRoot}
\alias{ShadowRoot}
\title{Create a shadow root}
\description{
A shadow DOM is a self-contained DOM tree, contained within another DOM
tree. A shadow root is an element that contains a DOM subtree. This class
represents a shadow root object, allowing you to select elements within
the shadow root.
}
\examples{

## ------------------------------------------------
## Method `ShadowRoot$new`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  div.attachShadow({mode: 'open'});
")

element <- session$find_element(using = "css selector", value = "div")

element$shadow_root()

session$close()
}

## ------------------------------------------------
## Method `ShadowRoot$find_element`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  const shadowRoot = div.attachShadow({mode: 'open'});
  const span = document.createElement('span');
  span.textContent = 'Hello';
  shadowRoot.appendChild(span);
")

element <- session$find_element(using = "css selector", value = "div")

shadow_root <- element$shadow_root()

shadow_root$find_element(using = "css selector", value = "span")

session$close()
}

## ------------------------------------------------
## Method `ShadowRoot$find_elements`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  const shadowRoot = div.attachShadow({mode: 'open'});
  const span = document.createElement('span');
  span.textContent = 'Hello';
  shadowRoot.appendChild(span);
  const p = document.createElement('p');
  p.textContent = 'Me too!';
  shadowRoot.appendChild(p);
")

element <- session$find_element(using = "css selector", value = "div")

shadow_root <- element$shadow_root()

shadow_root$find_elements(using = "css selector", value = "*")

session$close()
}

## ------------------------------------------------
## Method `ShadowRoot$toJSON`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  div.attachShadow({mode: 'open'});
")

element <- session$find_element(using = "css selector", value = "div")

shadow_root <- element$shadow_root()

result <- shadow_root$toJSON()

result

jsonlite::toJSON(result, auto_unbox = TRUE)

session$close()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{The id of the shadow root.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ShadowRoot-new}{\code{ShadowRoot$new()}}
\item \href{#method-ShadowRoot-find_element}{\code{ShadowRoot$find_element()}}
\item \href{#method-ShadowRoot-find_elements}{\code{ShadowRoot$find_elements()}}
\item \href{#method-ShadowRoot-toJSON}{\code{ShadowRoot$toJSON()}}
\item \href{#method-ShadowRoot-clone}{\code{ShadowRoot$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ShadowRoot-new"></a>}}
\if{latex}{\out{\hypertarget{method-ShadowRoot-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new \code{ShadowRoot} object. This should not be called
manually: instead use \link[=WebElement]{WebElement$shadow_root()}, or
\link[=SeleniumSession]{SeleniumSession$create_shadow_root()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShadowRoot$new(session_id, req, verbose, id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session_id}}{The id of the session.}

\item{\code{req, verbose}}{Private fields of a \link{SeleniumSession} object.}

\item{\code{id}}{The id of the shadow root.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{ShadowRoot} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  div.attachShadow({mode: 'open'});
")

element <- session$find_element(using = "css selector", value = "div")

element$shadow_root()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ShadowRoot-find_element"></a>}}
\if{latex}{\out{\hypertarget{method-ShadowRoot-find_element}{}}}
\subsection{Method \code{find_element()}}{
Find an element in the shadow root.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShadowRoot$find_element(
  using = c("css selector", "xpath", "tag name", "link text", "partial link text"),
  value,
  request_body = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{using}}{The type of selector to use.}

\item{\code{value}}{The value of the selector: a string.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{WebElement} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  const shadowRoot = div.attachShadow({mode: 'open'});
  const span = document.createElement('span');
  span.textContent = 'Hello';
  shadowRoot.appendChild(span);
")

element <- session$find_element(using = "css selector", value = "div")

shadow_root <- element$shadow_root()

shadow_root$find_element(using = "css selector", value = "span")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ShadowRoot-find_elements"></a>}}
\if{latex}{\out{\hypertarget{method-ShadowRoot-find_elements}{}}}
\subsection{Method \code{find_elements()}}{
Find all elements in a shadow root matching a selector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShadowRoot$find_elements(
  using = c("css selector", "xpath", "tag name", "link text", "partial link text"),
  value,
  request_body = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{using}}{The type of selector to use.}

\item{\code{value}}{The value of the selector: a string.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of \link{WebElement} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  const shadowRoot = div.attachShadow({mode: 'open'});
  const span = document.createElement('span');
  span.textContent = 'Hello';
  shadowRoot.appendChild(span);
  const p = document.createElement('p');
  p.textContent = 'Me too!';
  shadowRoot.appendChild(p);
")

element <- session$find_element(using = "css selector", value = "div")

shadow_root <- element$shadow_root()

shadow_root$find_elements(using = "css selector", value = "*")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ShadowRoot-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-ShadowRoot-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
Convert an element to JSON. This is used by
\link[=SeleniumSession]{SeleniumSession$execute_script()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShadowRoot$toJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list, which can then be converted to JSON using
\code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

# Let's create our own Shadow Root using JavaScript
session$execute_script("
  const div = document.createElement('div');
  document.body.appendChild(div);
  div.attachShadow({mode: 'open'});
")

element <- session$find_element(using = "css selector", value = "div")

shadow_root <- element$shadow_root()

result <- shadow_root$toJSON()

result

jsonlite::toJSON(result, auto_unbox = TRUE)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ShadowRoot-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ShadowRoot-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShadowRoot$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
