% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_forecasts.R
\name{find_duplicates}
\alias{find_duplicates}
\title{Find duplicate forecasts}
\usage{
find_duplicates(data, forecast_unit, ...)
}
\arguments{
\item{data}{A data.frame as used for \code{\link[=score]{score()}}}

\item{forecast_unit}{A character vector with the column names that define
the unit of a single forecast. If missing the function tries to infer the
unit of a single forecast.}

\item{...}{Additional arguments passed to \code{\link[=get_forecast_unit]{get_forecast_unit()}}.}
}
\value{
A data.frame with all rows for which a duplicate forecast was found
}
\description{
Helper function to identify duplicate forecasts, i.e.
instances where there is more than one forecast for the same prediction
target.
}
\examples{
example <- rbind(example_quantile, example_quantile[1000:1010])
find_duplicates(example)
}
\keyword{check-forecasts}
