% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec.R
\name{vec_poke_n}
\alias{vec_poke_n}
\alias{vec_poke_range}
\title{Poke values into a vector}
\usage{
vec_poke_n(x, start, y, from = 1L, n = length(y))

vec_poke_range(x, start, y, from = 1L, to = length(y) - from + 1L)
}
\arguments{
\item{x}{The destination vector.}

\item{start}{The index indicating where to start modifying \code{x}.}

\item{y}{The source vector.}

\item{from}{The index indicating where to start copying from \code{y}.}

\item{n}{How many elements should be copied from \code{y} to \code{x}.}

\item{to}{The index indicating the end of the range to copy from \code{y}.}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("experimental")}

These tools are for R experts only. They copy elements from \code{y}
into \code{x} by mutation. You should only do this if you own \code{x},
i.e. if you have created it or if you are certain that it doesn't
exist in any other context. Otherwise you might create unintended
side effects that have undefined consequences.
}
\keyword{internal}
