% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{generate_cornell_mesh}
\alias{generate_cornell_mesh}
\title{Cornell Box 3D Model}
\usage{
generate_cornell_mesh(
  leftcolor = "#1f7326",
  rightcolor = "#a60d0d",
  roomcolor = "#bababa",
  ceiling = TRUE,
  light = TRUE
)
}
\arguments{
\item{leftcolor}{Default \verb{#1f7326} (green).}

\item{rightcolor}{Default \verb{#a60d0d} (red).}

\item{roomcolor}{Default \verb{#bababa} (light grey).}

\item{ceiling}{Default \code{TRUE}. Whether to render the ceiling.}

\item{light}{Default \code{TRUE}. Whether to render a point light near the ceiling.}
}
\value{
List describing the mesh.
}
\description{
Cornell Box 3D Model
}
\examples{
if(run_documentation()) {
#Generate and render the default Cornell box and add an object.
generate_cornell_mesh() |> 
  rasterize_scene()
}
if(run_documentation()) {
#Add an object to the scene
generate_cornell_mesh() |> 
  add_shape(obj_mesh(r_obj(),position=c(555/2,0,555/2),scale=150,angle=c(0,180,0))) |> 
  rasterize_scene()
}
if(run_documentation()) {
#Turn off the ceiling so the default directional light reaches inside the box
generate_cornell_mesh(ceiling=FALSE) |> 
  add_shape(obj_mesh(r_obj(),position=c(555/2,0,555/2),scale=150,angle=c(0,180,0))) |> 
  rasterize_scene()
}
if(run_documentation()) {
#Adjust the light to the front
generate_cornell_mesh(ceiling=FALSE) |> 
  add_shape(obj_mesh(r_obj(),position=c(555/2,0,555/2),scale=150,angle=c(0,180,0))) |> 
  rasterize_scene(light_info = directional_light(direction=c(0,1,-1)))
  }
if(run_documentation()) {
#Change the color palette
generate_cornell_mesh(ceiling=FALSE,leftcolor="purple", rightcolor="yellow") |> 
  add_shape(obj_mesh(r_obj(),position=c(555/2,0,555/2),scale=150,angle=c(0,180,0))) |> 
  rasterize_scene(light_info = directional_light(direction=c(0,1,-1)))
}
}
