% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe_miscs.R, R/pre.R
\name{print.gpe}
\alias{print.gpe}
\alias{print.pre}
\title{Print method for objects of class pre}
\usage{
\method{print}{gpe}(x, penalty.par.val = "lambda.1se",
  digits = getOption("digits"), ...)

\method{print}{pre}(x, penalty.par.val = "lambda.1se",
  digits = getOption("digits"), ...)
}
\arguments{
\item{x}{An object of class \code{\link{pre}}.}

\item{penalty.par.val}{character. Information for which final prediction rule
ensemble(s) should be printed? The ensemble with penalty parameter criterion 
yielding minimum cv error (\code{"lambda.min"}) or penalty parameter 
yielding error within 1 standard error of minimum cv error 
("\code{lambda.1se}")? Alternatively, a numeric value may be specified, 
corresponding to one of the values of lambda in the sequence used by glmnet,
for which estimated cv error can be inspected by running \code{x$glmnet.fit}
and \code{plot(x$glmnet.fit)}.}

\item{digits}{Number of digits to print}

\item{...}{Additional arguments, currently not used}
}
\value{
Prints information about the fitted prediction rule ensemble.
}
\description{
\code{print.pre} prints information about the generated prediction rule 
ensemble to the command line
}
\details{
Note that the cv error is estimated with data that was also used 
for learning rules and may be too optimistic. Use cvpre() to obtain an 
accurate estimate of future prediction error.
}
\examples{
\donttest{
set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
print(airq.ens)}
}
\seealso{
\code{\link{pre}}, \code{\link{plot.pre}}, 
\code{\link{coef.pre}}, \code{\link{importance}}, \code{\link{predict.pre}}, 
\code{\link{interact}}, \code{\link{cvpre}}
}
