% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztest.paired.R
\name{ztest.paired}
\alias{ztest.paired}
\title{Power calculation for paired z test}
\usage{
ztest.paired(
  N = NULL,
  delta = NULL,
  sd1 = 1,
  sd2 = NULL,
  rho = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size; the number of pairs.}

\item{delta}{DeltaA (the true mean difference) - Delta0 (the mean difference under the null).}

\item{sd1}{The pre standard deviation; defaults to 1.}

\item{sd2}{The post standard deviation; defaults to the value of sd1.}

\item{rho}{The correlation between pre and post measurements on the same individual; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for a paired z test which is
analogous to a paired t test with variance assumed to be known.
This function is provided largely for pedagogical purposes; in general,
for real studies, the paired t test procedure should be used.
}
\examples{
ztest.paired(N = NULL, delta = 4, sd1 = 10, sd2 = 10, rho = 0.4, power = 0.8, sides = 2)
}
