/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.resources.colors.CIEBasedA;
import net.sf.eps2pgf.ps.resources.colors.CIEBasedABC;
import net.sf.eps2pgf.ps.resources.colors.DeviceCMYK;
import net.sf.eps2pgf.ps.resources.colors.DeviceGray;
import net.sf.eps2pgf.ps.resources.colors.DeviceRGB;
import net.sf.eps2pgf.ps.resources.colors.Indexed;
import net.sf.eps2pgf.ps.resources.colors.PSColor;

public final class ColorManager {
    private ColorManager() {
    }

    public static PSColor autoSetColorSpace(PSObject pSObject) throws PSError, ProgramError {
        PSObjectName pSObjectName;
        if (pSObject instanceof PSObjectName) {
            pSObjectName = (PSObjectName)pSObject;
        } else if (pSObject instanceof PSObjectArray) {
            pSObjectName = ((PSObjectArray)pSObject).get(0).toName();
        } else {
            throw new PSErrorTypeCheck();
        }
        if (pSObjectName.eq(DeviceGray.FAMILYNAME)) {
            return new DeviceGray();
        }
        if (pSObjectName.eq(DeviceRGB.FAMILYNAME)) {
            return new DeviceRGB();
        }
        if (pSObjectName.eq(DeviceCMYK.FAMILYNAME)) {
            return new DeviceCMYK();
        }
        if (pSObjectName.eq(Indexed.FAMILYNAME)) {
            return new Indexed(pSObject);
        }
        if (pSObjectName.eq(CIEBasedABC.FAMILYNAME)) {
            return new CIEBasedABC(pSObject.toArray());
        }
        if (pSObjectName.eq(CIEBasedA.FAMILYNAME)) {
            return new CIEBasedA(pSObject.toArray());
        }
        throw new PSErrorUndefined();
    }

    public static boolean colorSpaceFamilyStatus(PSObject pSObject) throws PSError {
        String string = String.format("net.sf.eps2pgf.ps.resources.colors.%s", pSObject.toString());
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

