% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendPed.R
\name{appendPed}
\alias{appendPed}
\title{Simulate new generations from an existing pedigree}
\usage{
appendPed(
  ped,
  Va0,
  Ve,
  littersize = 1,
  ngen,
  mort.rate = 0,
  overlap.s = 0,
  overlap.d = 0,
  f.rate = 1,
  m.rate = 1,
  fsel = "R",
  msel = "R",
  f.order = "fsel",
  m.order = "msel",
  seed = NA
)
}
\arguments{
\item{ped}{: The input pedigree \code{data.frame} with 9 columns: ID, SIRE, DAM, SEX,
GEN (generation), PA (parent average), MS (Mendelian Sampling), E (environment and residuals), and P (phenotype).
Note that PA + MS + E = P - \eqn{\mu}, where \eqn{\mu} is the population mean,
and PA + MS = BV (genetic merit or breeding value).
If MS and E are unknown, those can be set to 0.
PA should be equal to the average of sire BV (SBV) and dam BV (DBV).
If this condition is not met, PA - (SBV + DBV)/2 is added to MS and (SBV + DBV)/2 replaces PA.}

\item{Va0}{: Additive genetic variance in the base generation (i.e., F0).}

\item{Ve}{: Residual variance, constant across generations.}

\item{littersize}{: Litter size, default = 1.}

\item{ngen}{: Number of generations to simulate after the founder generation.}

\item{mort.rate}{: Mortality rate per generation, after the availability of phenotype (e.g., birth weight, weaning weight)
and before the age of maturity (i.e., before mating), default = 0. Maximum \code{mort.rate} = 0.5.}

\item{overlap.s}{: Number of overlapping generations for sires, default = 0 for no generation overlap.}

\item{overlap.d}{: Number of overlapping generations for dams, default = 0 for no generation overlap.}

\item{f.rate}{: Proportion of females selected as dams, default = 1.}

\item{m.rate}{: Proportion of males (\code{<= f.rate}) selected as sires, default = 1.}

\item{fsel}{: If \code{"R"} (default), random selection on females;
if \code{"P"}, selection on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, selection on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{msel}{: If \code{"R"} (default), random selection on males;
 if \code{"P"}, selection on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, selection on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{f.order}{: Ordering selected females for mating;
if \code{"fsel"} (default), same as the selection order;
if \code{"R"} random ordering;
if \code{"P"}, ordering based on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, ordering based on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{m.order}{: Ordering selected males for mating;
if \code{"msel"} (default), same as the selection order;
if \code{"R"} random ordering;
if \code{"P"}, ordering based on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, ordering based on true parent averages.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{seed}{: A numeric variable input to the random number generator for reproducible simulations,
default = `NA` for non-reproducible simulations.}
}
\value{
ped2 : New generations appended to the input pedigree \code{data.frame}.
}
\description{
Simulate pedigree, genetic merits and phenotypes with random/assortative/disassortative matings
followed by random/non-random selection of males and females with similar/different selection patterns in males and females,
starting from an existing pedigree.
}
\examples{
ped = simulatePed(
    F0size = 100,
    Va0 = 9,
    Ve = 36,
    littersize = 2,
    ngen = 4,
    mort.rate = 0.05,
    overlap.s = 1,
    overlap.d = 0,
    f.rate = 0.8,
    m.rate = 0.5,
    fsel = "P",
    msel = "PA"
)
ped2 = appendPed(
    ped = ped,
    Va0 = 9,
    Ve = 36,
    littersize = 2,
    ngen = 2,
    mort.rate = 0.05,
    overlap.s = 1,
    overlap.d = 0,
    f.rate = 0.8,
    m.rate = 0.5,
    fsel = "R",
    msel = "R",
    f.order = "P",
    m.order = "PA",
    seed = 76
)

}
