\name{ DistributedMatrixCreation }

\docType{methods}

\alias{ddmatrix-method}
\alias{ddmatrix,character-method}
\alias{ddmatrix,matrix-method}
\alias{ddmatrix,missing-method}
\alias{ddmatrix,vector-method}
%\alias{ddmatrix}

\alias{ddmatrix.local-method}
\alias{ddmatrix.local,character-method}
\alias{ddmatrix.local,matrix-method}
\alias{ddmatrix.local,missing-method}
\alias{ddmatrix.local,vector-method}
\alias{ddmatrix.local}

\alias{ddmatrix.local-method}
\alias{ddmatrix.local,character-method}
\alias{ddmatrix.local,matrix-method}
\alias{ddmatrix.local,missing-method}
\alias{ddmatrix.local,vector-method}
\alias{ddmatrix.local}

\title{ Distributed Matrix Creation }

\description{
  Methods for simple construction of distributed matrices.
}
\section{Methods}{
\describe{
\item{\code{signature(data = "character")}}{}
\item{\code{signature(data = "matrix")}}{}
\item{\code{signature(data = "missing")}}{}
\item{\code{signature(data = "vector")}}{}
}
}
\usage{
  \S4method{ddmatrix}{character}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., min = 0, max = 1, mean = 0, sd = 1,
                                 rate = 1, shape, scale = 1, 
                                  bldim = .BLDIM, ICTXT = .ICTXT)
  \S4method{ddmatrix}{matrix}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., bldim = .BLDIM, ICTXT = .ICTXT)
  \S4method{ddmatrix}{missing}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., bldim = .BLDIM, ICTXT = .ICTXT)
  \S4method{ddmatrix}{vector}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., bldim = .BLDIM, ICTXT = .ICTXT)
  \S4method{ddmatrix.local}{character}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., min = 0, max = 1, mean = 0, sd = 1,
                                 rate = 1, shape, scale = 1, 
                                  bldim = .BLDIM, ICTXT = .ICTXT)
  \S4method{ddmatrix.local}{matrix}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., bldim = .BLDIM, ICTXT = .ICTXT)
  \S4method{ddmatrix.local}{missing}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., bldim = .BLDIM, ICTXT = .ICTXT)
  \S4method{ddmatrix.local}{vector}(data, nrow = 1, ncol = 1, byrow = FALSE,
                                 ..., bldim = .BLDIM, ICTXT = .ICTXT)
}
\arguments{
  \item{data}{optional data vector.}
  \item{nrow}{number of rows.  Global rows for \code{ddmatrix()}. Local
  rows for \code{ddmatrix.local()}.  See details below.}
  \item{ncol}{number of columns.  Global columns for \code{ddmatrix()}. 
  Local columns for \code{ddmatrix.local()}.  See details below.}
  \item{byrow}{logical. If \code{FALSE} then the distributed matrix will
  be filled by column major storage, otherwise row-major.}
  \item{...}{Extra arguments}
  \item{min, max}{Min and max values for random uniform generation.}
  \item{mean,sd}{Mean and standard deviation for random normal generation.}
  \item{rate}{Rate for random exponential generation.}
  \item{shape,scale}{Shape and scale parameters for random weibull generation.}
  \item{bldim}{blocking dimension.}
  \item{ICTXT}{BLACS context number.}
}
\details{
  These methods are simplified methods of creating distributed matrices,
  including random ones.  These methods involve only local computations,
  i.e., no communication is performed in the construction of a \code{ddmatrix}
  using these methods (in contrast to using \code{as.ddmatrix()} et al).
  
  For non-character inputs, the methods attempt to mimic R as closely
  as possible.  So \code{ddmatrix(1:3, 5, 7)} produces the distributed
  analogue of \code{matrix(1:3, 5, 7)}. 
  
  For character inputs, you may also specify additional parametric family
  information.
  
  The functions predicated with \code{.local} generate data with a 
  fixed local dimension, i.e., each processor gets an identical amount
  of data.  Likewise, the remaining functions generate a fixed global
  amount of data, and each processor may or may not have an identical 
  amount of local data.
  
  To ensure good random number generation, you should only consider 
  using the character methods with the \code{comm.set.seed()} function 
  from pbdMPI which uses the method of L'Ecuyer via the rlecuyer package.
}
\value{
  Returns a distributed matrix.
}
\seealso{
  \code{\link{as.ddmatrix}}
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

dx <- ddmatrix(data="rnorm", nrow=5, ncol=6, mean=10, sd=100)
dy <- ddmatrix(data=1:4, nrow=7, ncol=5)

print(dx)
print(dy)

finalize()
}
}
\keyword{Data Generation}


