% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestarnotifications_operations.R
\name{codestarnotifications_create_notification_rule}
\alias{codestarnotifications_create_notification_rule}
\title{Creates a notification rule for a resource}
\usage{
codestarnotifications_create_notification_rule(
  Name,
  EventTypeIds,
  Resource,
  Targets,
  DetailType,
  ClientRequestToken = NULL,
  Tags = NULL,
  Status = NULL
)
}
\arguments{
\item{Name}{[required] The name for the notification rule. Notification rule names must be
unique in your Amazon Web Services account.}

\item{EventTypeIds}{[required] A list of event types associated with this notification rule. For a list
of allowed events, see EventTypeSummary.}

\item{Resource}{[required] The Amazon Resource Name (ARN) of the resource to associate with the
notification rule. Supported resources include pipelines in
CodePipeline, repositories in CodeCommit, and build projects in
CodeBuild.}

\item{Targets}{[required] A list of Amazon Resource Names (ARNs) of Amazon Simple Notification
Service topics and Chatbot clients to associate with the notification
rule.}

\item{DetailType}{[required] The level of detail to include in the notifications for this resource.
\code{BASIC} will include only the contents of the event as it would appear
in Amazon CloudWatch. \code{FULL} will include any supplemental information
provided by AWS CodeStar Notifications and/or the service for the
resource for which the notification is created.}

\item{ClientRequestToken}{A unique, client-generated idempotency token that, when provided in a
request, ensures the request cannot be repeated with a changed
parameter. If a request with the same parameters is received and a token
is included, the request returns information about the initial request
that used that token.

The Amazon Web Services SDKs prepopulate client request tokens. If you
are using an Amazon Web Services SDK, an idempotency token is created
for you.}

\item{Tags}{A list of tags to apply to this notification rule. Key names cannot
start with "\code{aws}".}

\item{Status}{The status of the notification rule. The default value is \code{ENABLED}. If
the status is set to \code{DISABLED}, notifications aren't sent for the
notification rule.}
}
\description{
Creates a notification rule for a resource. The rule specifies the events you want notifications about and the targets (such as Chatbot topics or Chatbot clients configured for Slack) where you want to receive them.

See \url{https://www.paws-r-sdk.com/docs/codestarnotifications_create_notification_rule/} for full documentation.
}
\keyword{internal}
