% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestarnotifications_service.R
\name{codestarnotifications}
\alias{codestarnotifications}
\title{AWS CodeStar Notifications}
\usage{
codestarnotifications(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This AWS CodeStar Notifications API Reference provides descriptions and
usage examples of the operations and data types for the AWS CodeStar
Notifications API. You can use the AWS CodeStar Notifications API to
work with the following objects:

Notification rules, by calling the following:
\itemize{
\item \code{\link[=codestarnotifications_create_notification_rule]{create_notification_rule}},
which creates a notification rule for a resource in your account.
\item \code{\link[=codestarnotifications_delete_notification_rule]{delete_notification_rule}},
which deletes a notification rule.
\item \code{\link[=codestarnotifications_describe_notification_rule]{describe_notification_rule}},
which provides information about a notification rule.
\item \code{\link[=codestarnotifications_list_notification_rules]{list_notification_rules}},
which lists the notification rules associated with your account.
\item \code{\link[=codestarnotifications_update_notification_rule]{update_notification_rule}},
which changes the name, events, or targets associated with a
notification rule.
\item \code{\link[=codestarnotifications_subscribe]{subscribe}}, which subscribes a
target to a notification rule.
\item \code{\link[=codestarnotifications_unsubscribe]{unsubscribe}}, which removes a
target from a notification rule.
}

Targets, by calling the following:
\itemize{
\item \code{\link[=codestarnotifications_delete_target]{delete_target}}, which
removes a notification rule target from a notification rule.
\item \code{\link[=codestarnotifications_list_targets]{list_targets}}, which lists
the targets associated with a notification rule.
}

Events, by calling the following:
\itemize{
\item \code{\link[=codestarnotifications_list_event_types]{list_event_types}}, which
lists the event types you can include in a notification rule.
}

Tags, by calling the following:
\itemize{
\item \code{\link[=codestarnotifications_list_tags_for_resource]{list_tags_for_resource}},
which lists the tags already associated with a notification rule in
your account.
\item \code{\link[=codestarnotifications_tag_resource]{tag_resource}}, which
associates a tag you provide with a notification rule in your
account.
\item \code{\link[=codestarnotifications_untag_resource]{untag_resource}}, which
removes a tag from a notification rule in your account.
}

For information about how to use AWS CodeStar Notifications, see the
\href{https://docs.aws.amazon.com/dtconsole/latest/userguide/what-is-dtconsole.html}{Amazon Web Services Developer Tools Console User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codestarnotifications(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=codestarnotifications_create_notification_rule]{create_notification_rule} \tab Creates a notification rule for a resource\cr
\link[=codestarnotifications_delete_notification_rule]{delete_notification_rule} \tab Deletes a notification rule for a resource\cr
\link[=codestarnotifications_delete_target]{delete_target} \tab Deletes a specified target for notifications\cr
\link[=codestarnotifications_describe_notification_rule]{describe_notification_rule} \tab Returns information about a specified notification rule\cr
\link[=codestarnotifications_list_event_types]{list_event_types} \tab Returns information about the event types available for configuring notifications\cr
\link[=codestarnotifications_list_notification_rules]{list_notification_rules} \tab Returns a list of the notification rules for an Amazon Web Services account\cr
\link[=codestarnotifications_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of the tags associated with a notification rule\cr
\link[=codestarnotifications_list_targets]{list_targets} \tab Returns a list of the notification rule targets for an Amazon Web Services account\cr
\link[=codestarnotifications_subscribe]{subscribe} \tab Creates an association between a notification rule and an Chatbot topic or Chatbot client so that the associated target can receive notifications when the events described in the rule are triggered\cr
\link[=codestarnotifications_tag_resource]{tag_resource} \tab Associates a set of provided tags with a notification rule\cr
\link[=codestarnotifications_unsubscribe]{unsubscribe} \tab Removes an association between a notification rule and an Chatbot topic so that subscribers to that topic stop receiving notifications when the events described in the rule are triggered\cr
\link[=codestarnotifications_untag_resource]{untag_resource} \tab Removes the association between one or more provided tags and a notification rule\cr
\link[=codestarnotifications_update_notification_rule]{update_notification_rule} \tab Updates a notification rule for a resource
}
}

\examples{
\dontrun{
svc <- codestarnotifications()
svc$create_notification_rule(
  Foo = 123
)
}

}
