% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codegurusecurity_operations.R
\name{codegurusecurity_get_findings}
\alias{codegurusecurity_get_findings}
\title{Returns a list of all findings generated by a particular scan}
\usage{
codegurusecurity_get_findings(
  maxResults = NULL,
  nextToken = NULL,
  scanName,
  status = NULL
)
}
\arguments{
\item{maxResults}{The maximum number of results to return in the response. Use this
parameter when paginating results. If additional results exist beyond
the number you specify, the \code{nextToken} element is returned in the
response. Use \code{nextToken} in a subsequent request to retrieve additional
results. If not specified, returns 1000 results.}

\item{nextToken}{A token to use for paginating results that are returned in the response.
Set the value of this parameter to null for the first request. For
subsequent calls, use the \code{nextToken} value returned from the previous
request to continue listing results after the first page.}

\item{scanName}{[required] The name of the scan you want to retrieve findings from.}

\item{status}{The status of the findings you want to get. Pass either \code{Open},
\code{Closed}, or \code{All}.}
}
\description{
Returns a list of all findings generated by a particular scan.

See \url{https://www.paws-r-sdk.com/docs/codegurusecurity_get_findings/} for full documentation.
}
\keyword{internal}
