% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeguruprofiler_operations.R
\name{codeguruprofiler_configure_agent}
\alias{codeguruprofiler_configure_agent}
\title{Used by profiler agents to report their current state and to receive
remote configuration updates}
\usage{
codeguruprofiler_configure_agent(
  fleetInstanceId = NULL,
  metadata = NULL,
  profilingGroupName
)
}
\arguments{
\item{fleetInstanceId}{A universally unique identifier (UUID) for a profiling instance. For
example, if the profiling instance is an Amazon EC2 instance, it is the
instance ID. If it is an AWS Fargate container, it is the container's
task ID.}

\item{metadata}{Metadata captured about the compute platform the agent is running on. It
includes information about sampling and reporting. The valid fields are:
\itemize{
\item \code{COMPUTE_PLATFORM} - The compute platform on which the agent is
running
\item \code{AGENT_ID} - The ID for an agent instance.
\item \code{AWS_REQUEST_ID} - The AWS request ID of a Lambda invocation.
\item \code{EXECUTION_ENVIRONMENT} - The execution environment a Lambda
function is running on.
\item \code{LAMBDA_FUNCTION_ARN} - The Amazon Resource Name (ARN) that is used
to invoke a Lambda function.
\item \code{LAMBDA_MEMORY_LIMIT_IN_MB} - The memory allocated to a Lambda
function.
\item \code{LAMBDA_REMAINING_TIME_IN_MILLISECONDS} - The time in milliseconds
before execution of a Lambda function times out.
\item \code{LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS} - The time in
milliseconds between two invocations of a Lambda function.
\item \code{LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS} - The time in
milliseconds for the previous Lambda invocation.
}}

\item{profilingGroupName}{[required] The name of the profiling group for which the configured agent is
collecting profiling data.}
}
\description{
Used by profiler agents to report their current state and to receive remote configuration updates. For example, \code{\link[=codeguruprofiler_configure_agent]{configure_agent}} can be used to tell an agent whether to profile or not and for how long to return profiling data.

See \url{https://www.paws-r-sdk.com/docs/codeguruprofiler_configure_agent/} for full documentation.
}
\keyword{internal}
