% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_list_allowed_repositories_for_group}
\alias{codeartifact_list_allowed_repositories_for_group}
\title{Lists the repositories in the added repositories list of the specified
restriction type for a package group}
\usage{
codeartifact_list_allowed_repositories_for_group(
  domain,
  domainOwner = NULL,
  packageGroup,
  originRestrictionType,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the package group from which to
list allowed repositories.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{packageGroup}{[required] The pattern of the package group from which to list allowed
repositories.}

\item{originRestrictionType}{[required] The origin configuration restriction type of which to list allowed
repositories.}

\item{maxResults}{The maximum number of results to return per page.}

\item{nextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}
}
\description{
Lists the repositories in the added repositories list of the specified restriction type for a package group. For more information about restriction types and added repository lists, see \href{https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-origin-controls.html}{Package group origin controls} in the \emph{CodeArtifact User Guide}.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_list_allowed_repositories_for_group/} for full documentation.
}
\keyword{internal}
