% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud9_operations.R
\name{cloud9_describe_environment_memberships}
\alias{cloud9_describe_environment_memberships}
\title{Gets information about environment members for an Cloud9 development
environment}
\usage{
cloud9_describe_environment_memberships(
  userArn = NULL,
  environmentId = NULL,
  permissions = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{userArn}{The Amazon Resource Name (ARN) of an individual environment member to
get information about. If no value is specified, information about all
environment members are returned.}

\item{environmentId}{The ID of the environment to get environment member information about.}

\item{permissions}{The type of environment member permissions to get information about.
Available values include:
\itemize{
\item \code{owner}: Owns the environment.
\item \code{read-only}: Has read-only access to the environment.
\item \code{read-write}: Has read-write access to the environment.
}

If no value is specified, information about all environment members are
returned.}

\item{nextToken}{During a previous call, if there are more than 25 items in the list,
only the first 25 items are returned, along with a unique string called
a \emph{next token}. To get the next batch of items in the list, call this
operation again, adding the next token to the call. To get all of the
items in the list, keep calling this operation with each subsequent next
token that is returned, until no more next tokens are returned.}

\item{maxResults}{The maximum number of environment members to get information about.}
}
\description{
Gets information about environment members for an Cloud9 development environment.

See \url{https://www.paws-r-sdk.com/docs/cloud9_describe_environment_memberships/} for full documentation.
}
\keyword{internal}
