% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestarnotifications_operations.R
\name{codestarnotifications_create_notification_rule}
\alias{codestarnotifications_create_notification_rule}
\title{Creates a notification rule for a resource}
\usage{
codestarnotifications_create_notification_rule(
  Name,
  EventTypeIds,
  Resource,
  Targets,
  DetailType,
  ClientRequestToken = NULL,
  Tags = NULL,
  Status = NULL
)
}
\arguments{
\item{Name}{[required] The name for the notification rule. Notifictaion rule names must be
unique in your AWS account.}

\item{EventTypeIds}{[required] A list of event types associated with this notification rule. For a list
of allowed events, see EventTypeSummary.}

\item{Resource}{[required] The Amazon Resource Name (ARN) of the resource to associate with the
notification rule. Supported resources include pipelines in AWS
CodePipeline, repositories in AWS CodeCommit, and build projects in AWS
CodeBuild.}

\item{Targets}{[required] A list of Amazon Resource Names (ARNs) of SNS topics to associate with
the notification rule.}

\item{DetailType}{[required] The level of detail to include in the notifications for this resource.
BASIC will include only the contents of the event as it would appear in
AWS CloudWatch. FULL will include any supplemental information provided
by AWS CodeStar Notifications and/or the service for the resource for
which the notification is created.}

\item{ClientRequestToken}{A unique, client-generated idempotency token that, when provided in a
request, ensures the request cannot be repeated with a changed
parameter. If a request with the same parameters is received and a token
is included, the request returns information about the initial request
that used that token.

The AWS SDKs prepopulate client request tokens. If you are using an AWS
SDK, an idempotency token is created for you.}

\item{Tags}{A list of tags to apply to this notification rule. Key names cannot
start with "aws".}

\item{Status}{The status of the notification rule. The default value is ENABLED. If
the status is set to DISABLED, notifications aren't sent for the
notification rule.}
}
\description{
Creates a notification rule for a resource. The rule specifies the events you want notifications about and the targets (such as SNS topics) where you want to receive them.

See \url{https://paws-r.github.io/docs/codestarnotifications/create_notification_rule.html} for full documentation.
}
\keyword{internal}
