% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2a_parameter_estimation_functions.R
\name{use_generalised_linear_mixed_model}
\alias{use_generalised_linear_mixed_model}
\title{Function for generalised linear mixed model}
\usage{
use_generalised_linear_mixed_model(
  param_to_be_estimated,
  dataset,
  fix_eff,
  fix_eff_interact_vars,
  random_intercept_vars,
  nested_intercept_vars_pairs,
  cross_intercept_vars_pairs,
  uncorrel_slope_intercept_pairs,
  random_slope_intercept_pairs,
  family,
  link
)
}
\arguments{
\item{param_to_be_estimated}{column name of dependent variable}

\item{dataset}{a dataframe}

\item{fix_eff}{names of variables as fixed effect predictors}

\item{fix_eff_interact_vars, }{those of the fixed effect predictors that
show interaction}

\item{random_intercept_vars, }{names of variables for random intercept}

\item{nested_intercept_vars_pairs, }{those of the random intercept variables
with nested effect}

\item{cross_intercept_vars_pairs, }{those of the random intercept variables
with crossed effect}

\item{uncorrel_slope_intercept_pairs, }{variables with no
correlated intercepts}

\item{random_slope_intercept_pairs, }{random slopes intercept pairs -
this is a list of paired variables}

\item{family, }{family of distributions for the response variable}

\item{link, }{link function for the variances}
}
\value{
result regression result with plot if success and -1, if failure
}
\description{
Function for generalised linear mixed model
}
\examples{
\donttest{
datafile <- system.file("extdata", "culcita_data.csv",
package = "packDAMipd")
dataset <- read.csv(datafile)
results1 = use_generalised_linear_mixed_model("predation",
dataset = datafile,fix_eff = c("ttt"), family = "binomial",
fix_eff_interact_vars = NULL, random_intercept_vars = c("block"),
nested_intercept_vars_pairs = NULL, cross_intercept_vars_pairs = NULL,
uncorrel_slope_intercept_pairs = NULL, random_slope_intercept_pairs = NULL,
 link = NA)
 }
}
