% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{removeFilter}
\alias{removeFilter}
\title{Remove a worksheet filter}
\usage{
removeFilter(wb, sheet)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A vector of names or indices of worksheets}
}
\description{
Removes filters from addFilter() and writeData()
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "Sheet 1")
addWorksheet(wb, "Sheet 2")
addWorksheet(wb, "Sheet 3")

writeData(wb, 1, iris)
addFilter(wb, 1, row = 1, cols = 1:ncol(iris))

## Equivalently
writeData(wb, 2, x = iris, withFilter = TRUE)

## Similarly
writeDataTable(wb, 3, iris)

## remove filters
removeFilter(wb, 1:2) ## remove filters
removeFilter(wb, 3) ## Does not affect tables!
\dontrun{
saveWorkbook(wb, file = "removeFilterExample.xlsx", overwrite = TRUE)
}
}
