% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSimPed.R
\name{makeSimPed}
\alias{makeSimPed}
\title{Makes a simulated pedigree using representative sires and dams}
\usage{
makeSimPed(ped, allSimParents, verbose = FALSE)
}
\arguments{
\item{ped}{pedigree information in data.frame format}

\item{allSimParents}{list made up of lists where the internal list
has the offspring ID \code{id}, a vector of representative sires
(\code{sires}), and a vector of representative dams (\code{dams}).}

\item{verbose}{logical vector of length one that indicates whether or not
to print out when an animal is missing a sire or a dam.}
}
\value{
simulated pedigree in data.frame format with the id, sire, and dam.
}
\description{
For each \code{id} in \code{allSimParents} with one or more unknown parents
each unknown parent is replaced with a random sire or dam as needed from
the corresponding parent vector (\code{sires} or \code{dams}).
}
\details{
The algorithm assigns parents randomly from the lists of possible sires and
dams and does not prevent a dam from being selected more than once within
the same breeding period. While this is probably not introducing a large
error, it is not ideal.
}
