% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_intensity_step.R
\name{draw_intensity_step}
\alias{draw_intensity_step}
\title{Simulate from a non homogeneous Poisson Point Process (NHPPP) from
(t0, t_max) (thinning method) with piecewise constant_majorizer}
\usage{
draw_intensity_step(lambda, majorizer_vector, time_breaks, atmost1 = FALSE)
}
\arguments{
\item{lambda}{(function) the instantaneous rate of the NHPPP.
A continuous function of time.}

\item{majorizer_vector}{(scalar, double) \code{K} constant majorizing rates, one per interval}

\item{time_breaks}{(vector, double) \code{K+1} time points defining \code{K} intervals
of constant rates:
\verb{[t_1 = range_t[1],       t_2)}: the first interval
\verb{[t_k,                t_\{k+1\})}: the \code{k}-th interval
\verb{[t_\{K\}, t_\{K+1\} = range_t[2])}: the \code{K}-th (last) interval}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times (t_); if no events realize,
a vector of length 0
}
\description{
Sample NHPPP times using the thinning method
}
\keyword{internal}
