% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmcif.R
\name{mmcif_logLik}
\alias{mmcif_logLik}
\alias{mmcif_logLik_grad}
\title{Evaluates the Log Composite Likelihood and its Gradient}
\usage{
mmcif_logLik(
  object,
  par,
  ghq_data = object$ghq_data,
  n_threads = 1L,
  is_log_chol = FALSE
)

mmcif_logLik_grad(
  object,
  par,
  ghq_data = object$ghq_data,
  n_threads = 1L,
  is_log_chol = FALSE
)
}
\arguments{
\item{object}{an object from \code{\link{mmcif_data}}.}

\item{par}{numeric vector with parameters. This is either using a log
Cholesky decomposition for the covariance matrix or the covariance matrix.}

\item{ghq_data}{the Gauss-Hermite quadrature nodes and weights to
use. It should be a list with two elements called \code{"node"}
and \code{"weight"}. A default is provided if \code{NULL} is passed.}

\item{n_threads}{the number of threads to use.}

\item{is_log_chol}{logical for whether a log Cholesky decomposition is used
for the covariance matrix or the full covariance matrix.}
}
\value{
A numeric vector with either the log composite likelihood or the gradient of
it.
}
\description{
Evaluates the log composite likelihood and its gradient using adaptive
Gauss-Hermite quadrature.
}
\examples{
if(require(mets)){
  # prepare the data
  data(prt)

  # truncate the time
  max_time <- 90
  prt <- within(prt, {
    status[time >= max_time] <- 0
    time <- pmin(time, max_time)
  })

  # select the DZ twins and re-code the status
  prt_use <- subset(prt, zyg == "DZ") |>
    transform(status = ifelse(status == 0, 3L, status))

  # randomly sub-sample
  set.seed(1)
  prt_use <- subset(
    prt_use, id \%in\% sample(unique(id), length(unique(id)) \%/\% 10L))

  n_threads <- 2L
  mmcif_obj <- mmcif_data(
    ~ country - 1, prt_use, status, time, id, max_time,
    2L, strata = country)

  # get the staring values
  start_vals <- mmcif_start_values(mmcif_obj, n_threads = n_threads)

  # compute the log composite likelihood and the gradient at the starting
  # values
  mmcif_logLik(
    mmcif_obj, start_vals$upper, is_log_chol = TRUE, n_threads = n_threads) |>
    print()
  mmcif_logLik_grad(
    mmcif_obj, start_vals$upper, is_log_chol = TRUE, n_threads = n_threads) |>
    print()
}

}
