% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{is_internode}
\alias{is_internode}
\title{Test if taxa are "internodes"}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object.}
}
\value{
A `logical` of length equal to the number of taxa.
}
\description{
Test if taxa are "internodes" in a [taxonomy()] or [taxmap()] object.  An
internode is any taxon with a single immediate supertaxon and a single immediate
subtaxon. They can be removed from a tree without any loss of information on
the relative relationship between remaining taxa.
\preformatted{
obj$is_internode()
is_internode(obj)}
}
\examples{
# Test for which taxon IDs correspond to internodes
is_internode(ex_taxmap)

# Filter out internodes
filter_taxa(ex_taxmap, ! is_internode)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data}()},
\code{\link{map_data_}()},
\code{\link{n_leaves}()},
\code{\link{n_leaves_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
