% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxmap--docs.R
\name{get_dataset}
\alias{get_dataset}
\title{Get a data set from a taxmap object}
\arguments{
\item{obj}{A taxmap object}

\item{data}{Dataset name, index, or a logical vector that indicates which dataset in
`obj$data` to add columns to.}
}
\description{
Get a data set from a taxmap object and complain if it does not
exist.
}
\examples{
# Get data set by name
get_dataset(ex_taxmap, "info")

# Get data set by indeex_taxmap
get_dataset(ex_taxmap, 1)

# Get data set by T/F vector
get_dataset(ex_taxmap, startsWith(names(ex_taxmap$data), "i"))

}
