% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations--differential_abundance.R
\name{calc_diff_abund_deseq2}
\alias{calc_diff_abund_deseq2}
\title{Differential abundance with DESeq2}
\usage{
calc_diff_abund_deseq2(
  obj,
  data,
  cols,
  groups,
  other_cols = FALSE,
  lfc_shrinkage = c("none", "normal", "ashr"),
  ...
)
}
\arguments{
\item{obj}{A \code{\link[metacoder]{taxmap}} object}

\item{data}{The name of a table in \code{obj} that contains data for each sample in columns.}

\item{cols}{The names/indexes of columns in \code{data} to use. By default, all numeric columns
are used. Takes one of the following inputs: \describe{ \item{TRUE/FALSE:}{All/No columns will
used.} \item{Character vector:}{The names of columns to use} \item{Numeric vector:}{The indexes
of columns to use} \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Use
the columns corresponding to \code{TRUE} values.} }}

\item{groups}{A vector defining how samples are grouped into "treatments". Must be the same order
and length as \code{cols}.}

\item{other_cols}{If \code{TRUE}, preserve all columns not in \code{cols} in the output. If
\code{FALSE}, dont keep other columns. If a column names or indexes are supplied, only preserve
those columns.}

\item{lfc_shrinkage}{What technique to use to adjust the log fold change results for low counts.
  Useful for ranking and visualizing log fold changes. Must be one of the following:
\describe{
  \item{'none'}{No log fold change adjustments.}
  \item{'normal'}{The original DESeq2 shrinkage estimator}
  \item{'ashr'}{Adaptive shrinkage estimator from the \code{ashr} package, using a fitted mixture of normals prior.}
}}

\item{...}{Passed to \code{\link[DESeq2]{results}} if the \code{lfc_shrinkage} option is "none"
and to \code{\link[DESeq2]{lfcShrink}} otherwise.}
}
\value{
A tibble with at least the taxon ID of the thing tested, the groups compared, and the
  DESeq2 results. The \code{log2FoldChange} values will be positive if \code{treatment_1} is more
  abundant and \code{treatment_2}.
}
\description{
EXPERIMENTAL: This function is still being tested and developed; use with caution. Uses the
\code{\link[DESeq2]{DESeq2-package}} package to conduct differential abundance analysis of count data. Counts can
be of OTUs/ASVs or taxa. The plotting function \code{\link{heat_tree_matrix}} is useful for
visualizing these results. See details section below for considerations on preparing data for
this analysis.
}
\details{
Data should be raw read counts, not rarefied, converted to proportions, or modified with any
other technique designed to correct for sample size since \code{\link[DESeq2]{DESeq2-package}} is designed to be
used with count data and takes into account unequal sample size when determining differential
abundance. Warnings will be given if the data is not integers or all sample sizes are equal.
}
\examples{
\donttest{
# Parse data for plotting
x = parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                   class_key = c(tax_rank = "taxon_rank", tax_name = "taxon_name"),
                   class_regex = "^(.+)__(.+)$")

# Get per-taxon counts
x$data$tax_table <- calc_taxon_abund(x, data = "tax_data", cols = hmp_samples$sample_id)

# Calculate difference between groups
x$data$diff_table <- calc_diff_abund_deseq2(x, data = "tax_table",
                                    cols = hmp_samples$sample_id,
                                    groups = hmp_samples$body_site)
                                    
# Plot results (might take a few minutes)
heat_tree_matrix(x,
                 data = "diff_table",
                 node_size = n_obs,
                 node_label = taxon_names,
                 node_color = ifelse(is.na(padj) | padj > 0.05, 0, log2FoldChange),
                 node_color_range = diverging_palette(),
                 node_color_trans = "linear",
                 node_color_interval = c(-3, 3),
                 edge_color_interval = c(-3, 3),
                 node_size_axis_label = "Number of OTUs",
                 node_color_axis_label = "Log2 fold change")

}

}
\seealso{
Other calculations: 
\code{\link{calc_group_mean}()},
\code{\link{calc_group_median}()},
\code{\link{calc_group_rsd}()},
\code{\link{calc_group_stat}()},
\code{\link{calc_n_samples}()},
\code{\link{calc_obs_props}()},
\code{\link{calc_prop_samples}()},
\code{\link{calc_taxon_abund}()},
\code{\link{compare_groups}()},
\code{\link{counts_to_presence}()},
\code{\link{rarefy_obs}()},
\code{\link{zero_low_counts}()}
}
\concept{calculations}
