% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logging.R
\name{openlog}
\alias{openlog}
\title{Open a new logfile}
\usage{
openlog(file, loglevel = -Inf, append = FALSE, sink = FALSE)
}
\arguments{
\item{file}{Name of logfile (character or writeable \code{\link{connection}})}

\item{loglevel}{Minimum priority level (numeric, optional)}

\item{append}{Append to logfile? (logical, optional)}

\item{sink}{Send all console output to logfile? (logical, optional)}
}
\value{
Invisible fully-qualified name of log file.
}
\description{
Open a new logfile
}
\details{
Open a new logfile. Messages will only appear in the logfile
if their \code{level} exceeds the log's \code{loglevel};
this allows you to easily change the amount of detail being logged.

Re-opening a logfile will erase the previous output unless \code{append}
is TRUE. Opening a new logfile when one is already open will temporarily
switch logging to that new file.

If \code{sink} is TRUE, all screen output will be captured (via \code{\link{sink}}).
}
\examples{
logfile <- openlog("test.log")
printlog("message")
closelog()
readLines(logfile)
}
\seealso{
\code{\link{printlog}} \code{\link{closelog}}
}

