% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori_tools.R
\name{qut}
\alias{qut}
\title{Automatic selection of nuclear norm regularization parameter}
\usage{
qut(Y, covmat, lambda2 = 0, q = 0.95, N = 100)
}
\arguments{
\item{Y}{A matrix of counts (contingency table).}

\item{covmat}{A (np)xK matrix of K covariates about rows and columns}

\item{lambda2}{A positive number, the regularization parameter for covariates main effects}

\item{q}{A number between \code{0} and \code{1}. The quantile of the distribution of $lambda_{QUT}$ to take.}

\item{N}{An integer. The number of parametric bootstrap samples to draw.}
}
\value{
the value of $lambda_{QUT}$ to use in LoRI.
}
\description{
Automatic selection of nuclear norm regularization parameter
}
\examples{
X = matrix(rnorm(30), 15)
Y = matrix(rpois(15, 1:15), 5)
lambda = qut(Y,X, 10, N=10)
}
