% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lastransform.r
\name{lastransform}
\alias{lastransform}
\title{Datum transformation for LAS objects}
\usage{
lastransform(las, CRSobj)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS}}

\item{CRSobj}{logical. Object of class \link[sp:CRS-class]{CRS} or of class character, in which
case it is converted to \link[sp:CRS-class]{CRS}.}
}
\value{
An object of class \link[lidR:LAS-class]{LAS} with coordinates XY transformed to the new
coordinate reference system. The header has been update by add the ESPG code or a WKT OGC CS string
as a function of the defined Global Encoding WKT bit (see LAS specifications).
}
\description{
A version of \link[rgdal:spTransform]{spTrasform} for \link[lidR:LAS-class]{LAS} objects.
Returns transformed coordinates of a \code{LAS} object from the projection of the object to the
the projection given by arguments.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile, select = "xyzrn")
crs <- sp::CRS("+init=epsg:26918")

las <- lastransform(las, crs)
}
