% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_typecast.r
\name{as.raster.lasmetrics}
\alias{as.raster.lasmetrics}
\title{Transform a \code{lasmetrics} object into a spatial \code{RasterLayer} object}
\usage{
\method{as.raster}{lasmetrics}(x, z = NULL, fun.aggregate = mean, ...)
}
\arguments{
\item{x}{a \code{lasmetrics} object}

\item{z}{character. If 3 columns or more, the names of the field to extract. If NULL returns
a RasterStack instead of a RasterLayer.}

\item{fun.aggregate}{Should the data be aggregated before casting? If the table does not
contain a single observation for each cell, then aggregation defaults to mean value with
a message.}

\item{...}{Internal use only.}
}
\value{
A \link[raster:RasterLayer-class]{RasterLayer} object from package \pkg{raster}
or a \link[raster:RasterStack-class]{RasterStack} if there are several layers.
}
\description{
Transform a \code{lasmetrics} object into a spatial \code{RasterLayer} object
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

meanHeight = grid_metrics(lidar, mean(Z))
rmeanHeight = as.raster(meanHeight)
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
\link[lidR:grid_canopy]{grid_canopy}
\link[lidR:grid_canopy]{grid_canopy}
\link[raster:raster]{raster}

Other cast: \code{\link{as.lasmetrics}},
  \code{\link{as.spatial}}
}
