% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_frame_lab.R
\name{add_frame_lab}
\alias{add_frame_lab}
\alias{afl}
\title{Add or Modify a Data Frame "Frame Label"}
\usage{
add_frame_lab(data, frame.lab = NULL)

afl(data, frame.lab = NULL)
}
\arguments{
\item{data}{a data.frame.}

\item{frame.lab}{quoted text of the descriptive data.frame label that you wish
to add to the data.frame.}
}
\value{
A data.frame, with a frame.lab attribute added to the attributes
meta-data
}
\description{
Add a 500-or-fewer-characters high-level descriptive label for your data.frame
as whole (e.g., nature, originator, population / sample, year created, general
contents, article citation).
}
\details{
\code{add_frame_lab} assigns an overall descriptive "frame label" for a data.frame,
which can be retrieved using \code{get_frame_lab.}

Note: \code{afl} is a compact alias for \code{add_frame_lab}: they do the same thing,
and the former is easier to type
}
\examples{
# add frame.lab to mtcars and assign to new data.frame mt2
mt2 <- add_frame_lab(mtcars, frame.lab = "Data extracted from the 1974 Motor
                    Trend US magazine, comprising fuel consumption and 10
                    aspects of automobile design and performance for 32
                    automobiles (1973–74 models). Source: Henderson and
                    Velleman (1981), Building multiple regression models
                    interactively. Biometrics, 37, 391–411.")

attr(mt2, "frame.lab") # check for attribute

get_frame_lab(mt2) # return frame.lab alongside data.frame name as a data.frame
}
