% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.kernelshap}
\alias{print.kernelshap}
\title{Prints "kernelshap" Object}
\usage{
\method{print}{kernelshap}(x, n = 2L, ...)
}
\arguments{
\item{x}{An object of class "kernelshap".}

\item{n}{Maximum number of rows of SHAP values, standard errors and feature values to print.}

\item{...}{Further arguments passed from other methods.}
}
\value{
Invisibly, the input is returned.
}
\description{
Prints "kernelshap" Object
}
\examples{
fit <- stats::lm(Sepal.Length ~ ., data = iris)
pred_fun <- function(X) stats::predict(fit, X)
s <- kernelshap(iris[1:3, -1], pred_fun = pred_fun, iris[-1])
s
}
\seealso{
\code{\link{kernelshap}}.
}
