% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_categorical_crossentropy}
\alias{k_categorical_crossentropy}
\title{Categorical crossentropy between an output tensor and a target tensor.}
\usage{
k_categorical_crossentropy(target, output, from_logits = FALSE, axis = -1)
}
\arguments{
\item{target}{A tensor of the same shape as \code{output}.}

\item{output}{A tensor resulting from a softmax (unless \code{from_logits} is
TRUE, in which case \code{output} is expected to be the logits).}

\item{from_logits}{Logical, whether \code{output} is the result of a softmax, or
is a tensor of logits.}

\item{axis}{Axis (axis indexes are 1-based). Pass -1 (the
default) to select the last axis.}
}
\value{
Output tensor.
}
\description{
Categorical crossentropy between an output tensor and a target tensor.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

