% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wgttest.R
\name{wgttest}
\alias{wgttest}
\title{Test whether sampling weights are needed}
\usage{
wgttest(model, weights, model_output = TRUE)
}
\arguments{
\item{model}{The unweighted linear model (must be \code{lm}) you want to check}

\item{weights}{The name of the weights column in \code{model}'s data frame
or a vector of weights equal in length to the number of observations
included in \code{model}.}

\item{model_output}{Should a summary of the model with weights as predictor
be printed? Default is TRUE, but you may not want it if you are trying to
declutter a document.}
}
\description{
Use the DuMouchel-Duncan (1983) test to assess the need for sampling weights
in your linear regression analysis.
}
\details{
This is designed to be similar to the \code{wgttest} macro for Stata
(\url{http://fmwww.bc.edu/repec/bocode/w/wgttest.html}). This method,
advocated for by DuMouchel and Duncan (1983), is fairly straightforward. To
decide whether weights are needed, the weights are added to the linear model
as a predictor and interaction with each other predictor. Then, an omnibus
test of significance is performed to compare the weights-added model to the
original; if insignificant, weights are not significantly related to the
result and you can use the more efficient estimation from unweighted OLS.
}
\examples{
# First, let's create some fake sampling weights
wts <- runif(50, 0, 5)
# Create model
fit <- lm(Income ~ Frost + Illiteracy + Murder,
          data = as.data.frame(state.x77))
# See if the weights change the model
wgttest(fit, wts)


}
\references{
DuMouchel, W. H. & Duncan, D.J. (1983). Using sample survey weights in
  multiple regression analyses of stratified samples. \emph{Journal of the
  American Statistical Association}, \emph{78}. 535-543.

Winship, C. & Radbill, L. (1994). Sampling weights and regression
  analysis. \emph{Sociological Methods and Research}, \emph{23}, 230-257.
}
