% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_ipea.R
\name{theme_ipea}
\alias{theme_ipea}
\title{Ggplot theme for Ipea charts and figures}
\usage{
theme_ipea(
  axis_lines = "full",
  axis_values = TRUE,
  legend.position = "right",
  grid.adjust = "horizontal",
  x_breaks = NULL,
  y_breaks = NULL,
  expand_x_limit = TRUE,
  expand_y_limit = TRUE,
  x_text_angle = 0,
  include_x_text_title = TRUE,
  include_y_text_title = TRUE,
  include_ticks = TRUE,
  ...
)
}
\arguments{
\item{axis_lines}{A character vector specifying the axis style. Valid options are
\code{"none"} (no axis lines), \code{"full"} (full-length axis lines), and
\code{"half"} (half-length axis lines), the default.}

\item{axis_values}{Logical value indicating whether to show text elements. If \code{TRUE},
axis text will be displayed in black; otherwise, they will
be hidden.}

\item{legend.position}{A character vector specifying the position of the
legend. Valid options are \code{"right"} (default), \code{"left"}, \code{"top"}, and
\code{"bottom"}.}

\item{grid.adjust}{Defines whether the grid lines should be \code{"horizontal"}
(default) or \code{"vertical"}.}

\item{x_breaks}{Numeric. The number of breaks on the x-axis}

\item{y_breaks}{Numeric. The number of breaks on the y-axis}

\item{expand_x_limit}{Logical value that indicates whether the x-axis
boundary should be expanded. If \code{TRUE}, the x-axis limits will be
expanded; otherwise there will be no change}

\item{expand_y_limit}{Logical value that indicates whether the y-axis
boundary should be expanded. If \code{TRUE}, the x-axis limits will be
expanded; otherwise there will be no change}

\item{x_text_angle}{Numeric. Angle in degrees of the text in the x-axis.}

\item{include_x_text_title}{Logical. Whether to include x text title Defaults to \code{TRUE}.}

\item{include_y_text_title}{Logical. Whether to include x text title. Defaults to \code{TRUE}.}

\item{include_ticks}{Logical. Whether to include ticks. Defaults to \code{TRUE}.}

\item{...}{Additional arguments to be passed to the \code{theme} function from the
\code{ggplot2} package.}
}
\value{
A custom theme for IPEA graphics.
}
\description{
Applies a custom theme for ggplot figures following the editorial
guidelines used by the Institute for Applied Economic Research - Ipea. The
function includes standardized formatting of options for axis lines, text,
}
\examples{
# Creating theme for ggplot2 graph using default arguments
library(ggplot2)
fig_raw <- ggplot() +
  geom_col(data = mtcars, aes(x = hp , y = mpg, fill = cyl)) +
  theme_ipea()

}
\seealso{
Other ggplot2 theme functions: 
\code{\link{scale_color_ipea}()},
\code{\link{scale_fill_ipea}()}
}
\concept{ggplot2 theme functions}
