% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipea_palette.R
\name{ipea_pal}
\alias{ipea_pal}
\title{Ipea palette}
\usage{
ipea_pal(
  palette = c("Blue", "Green", "Orange", "Pink", "Green-Blue", "Green-Blue-White",
    "Red-Blue", "Red-Blue-White", "Orange-Blue", "Orange-Blue-White", "Viridis",
    "Inferno", "Magma", "Plasma", "Cividis"),
  alpha = 1,
  begin = 0,
  end = 1,
  palette_direction = 1
)
}
\arguments{
\item{palette}{A character string indicating the color map option to use.
These options are available: 'Blue', 'Green', 'Orange', 'Pink', 'Red-Blue'
'Orange-Blue', 'Green-Blue', 'Viridis', 'Inferno', 'Magma', 'Plasma'
'Cividis'.}

\item{alpha}{The alpha transparency in a number between \code{0} and \code{1}.}

\item{begin}{The (corrected) hue in a number between \code{0} and \code{1} at which the color map begins.}

\item{end}{The (corrected) hue in a number between \code{0} and \code{1} at which the color map ends.}

\item{palette_direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of
colors is reversed.}
}
\value{
\code{ipea_palette} produces a character vector, \code{cv}, containing color hex codes.
This vector can be utilized to establish a custom color scheme for future graphics using \code{palette(cv)},
or it can be applied directly as a \code{col =} parameter in graphic functions or within \code{par}.
}
\description{
Ipea palette
}
\examples{
scales::show_col(ipea_pal()(10))
scales::show_col(ipea_pal(palette_direction = -1)(6))
scales::show_col(ipea_pal(begin = 0.2, end = 0.8)(4))
scales::show_col(ipea_pal(palette = "Green")(6))
}
\references{
'Blue','Green','Orange','Pink','Green-Blue','Green-Blue-White','Red-Blue','Red-Blue-White',
'Orange-Blue','Orange-Blue-White', 'Viridis','Inferno',
'Magma','Plasma' and 'Cividis': https://pmassicotte.github.io/paletteer_gallery/
}
