% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immundata.R
\name{ImmunData}
\alias{ImmunData}
\title{ImmunData: A Unified Structure for Immune Receptor Repertoire Data}
\description{
\code{ImmunData} is an abstract R6 class for managing and transforming immune receptor repertoire data.
It supports flexible backends (e.g., Arrow, DuckDB, dbplyr) and lazy evaluation,
and provides tools for filtering, aggregation, and receptor-to-repertoire mapping.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.receptors}}{A receptor-level table containing immune receptor features
(e.g., CDR3, V/J gene, clonotype ID, counts). This table is typically aggregated
and is used for quantitative analysis of immune repertoire signatures.
It can be a local tibble, Arrow Table, DuckDB table, or any other
\code{dplyr}-compatible backend (including lazy data sources).}

\item{\code{.annotations}}{A barcode-level table that links each barcode (i.e., cell ID)
to a receptor in \code{.receptors}. It can also store cell-level metadata such as
sample ID, donor, or tissue source. This table is \strong{not aggregated} and
typically contains one row per barcode.}

\item{\code{schema_receptor}}{A named list describing how to interpret receptor-level data.
This includes the fields used for aggregation (e.g., \code{CDR3}, \code{V_gene}, \code{J_gene}),
and optionally unique identifiers for each receptor row. Used to ensure consistency
across processing steps.}

\item{\code{schema_repertoire}}{A named list defining how barcodes or annotations should be
grouped into repertoires. This may include sample-level metadata (e.g., \code{sample_id},
\code{donor_id}) used to define unique repertoires.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{receptors}}{Accessor for the receptor-level table (\code{.receptors}).}

\item{\code{annotations}}{Accessor for the annotation-level table (\code{.annotations}).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ImmunData-new}{\code{ImmunData$new()}}
\item \href{#method-ImmunData-build_repertoires}{\code{ImmunData$build_repertoires()}}
\item \href{#method-ImmunData-print}{\code{ImmunData$print()}}
\item \href{#method-ImmunData-filter_receptors}{\code{ImmunData$filter_receptors()}}
\item \href{#method-ImmunData-filter_annotations}{\code{ImmunData$filter_annotations()}}
\item \href{#method-ImmunData-filter_barcodes}{\code{ImmunData$filter_barcodes()}}
\item \href{#method-ImmunData-clone}{\code{ImmunData$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImmunData-new"></a>}}
\if{latex}{\out{\hypertarget{method-ImmunData-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{ImmunData} object.
This constructor expects receptor-level and barcode-level data,
along with a receptor schema defining aggregation and identity fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImmunData$new(receptors, annotations, schema)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{receptors}}{A receptor-level dataset (e.g., grouped by CDR3/V/J).}

\item{\code{annotations}}{A cell/barcode-level dataset mapping barcodes to receptor rows.}

\item{\code{schema}}{A named list specifying the receptor schema (e.g., aggregate fields, ID columns).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImmunData-build_repertoires"></a>}}
\if{latex}{\out{\hypertarget{method-ImmunData-build_repertoires}{}}}
\subsection{Method \code{build_repertoires()}}{
Defines repertoires by concatenating selected annotation columns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImmunData$build_repertoires(schema = "repertoire_id", sep = "-")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schema}}{A character vector of column names in \code{.annotations} used to define repertoire grouping.}

\item{\code{sep}}{A string separator used to concatenate multiple columns into a single repertoire ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImmunData-print"></a>}}
\if{latex}{\out{\hypertarget{method-ImmunData-print}{}}}
\subsection{Method \code{print()}}{
Prints class information for the \code{ImmunData} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImmunData$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImmunData-filter_receptors"></a>}}
\if{latex}{\out{\hypertarget{method-ImmunData-filter_receptors}{}}}
\subsection{Method \code{filter_receptors()}}{
Filters the receptor-level data using tidyverse filter syntax,
and then updates the annotation table to include only linked barcodes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImmunData$filter_receptors(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Filtering conditions applied to the receptor-level table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ImmunData} object with filtered receptor and annotation tables.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImmunData-filter_annotations"></a>}}
\if{latex}{\out{\hypertarget{method-ImmunData-filter_annotations}{}}}
\subsection{Method \code{filter_annotations()}}{
Filters the annotation-level table using tidyverse filter syntax,
and updates the receptor table to include only matching receptor entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImmunData$filter_annotations(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Filtering conditions applied to the annotations table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ImmunData} object with filtered annotation and receptor tables.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImmunData-filter_barcodes"></a>}}
\if{latex}{\out{\hypertarget{method-ImmunData-filter_barcodes}{}}}
\subsection{Method \code{filter_barcodes()}}{
Filters the dataset by a set of barcodes (unique cell IDs).
The resulting object contains only rows linked to those barcodes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImmunData$filter_barcodes(barcodes = c())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{barcodes}}{A character vector of barcodes to retain.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ImmunData} object filtered by barcode.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImmunData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ImmunData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImmunData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
