% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-auth-code.R
\name{oauth_flow_auth_code_url}
\alias{oauth_flow_auth_code_url}
\alias{oauth_flow_auth_code_listen}
\alias{oauth_flow_auth_code_parse}
\alias{oauth_flow_auth_code_pkce}
\title{OAuth authorization code components}
\usage{
oauth_flow_auth_code_url(
  client,
  auth_url,
  redirect_uri = NULL,
  scope = NULL,
  state = NULL,
  auth_params = list()
)

oauth_flow_auth_code_listen(redirect_uri = "http://localhost:1410")

oauth_flow_auth_code_parse(query, state)

oauth_flow_auth_code_pkce()
}
\arguments{
\item{state}{Random state generated by \code{oauth_flow_auth_code()}. Used to
verify that we're working with an authentication request that we created.
(This is an unlikely threat for R packages since the webserver that
listens for authorization responses is transient.)}

\item{query}{List of query parameters returned by \code{oauth_flow_auth_code_listen()}.}
}
\description{
These low-level functions can be used to assemble a custom flow for
APIs that are further from the spec:
\itemize{
\item \code{oauth_flow_auth_code_url()} generates the url that should be opened in a
browser.
\item \code{oauth_flow_auth_code_listen()} starts a temporary local webserver that
listens for the response from the resource server.
\item \code{oauth_flow_auth_code_parse()} parses the query parameters returned from
the server redirect, verifying that the \code{state} is correct, and returning
the authorisation code.
\item \code{oauth_flow_auth_code_pkce()} generates code verifier, method, and challenge
components as needed for PKCE, as defined in \href{https://datatracker.ietf.org/doc/html/rfc7636}{RFC 7636}.
}
}
\keyword{internal}
