% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsdf.R
\name{tsdf}
\alias{tsdf}
\title{Time series to data frame}
\usage{
tsdf(timeseries, colname = "x")
}
\arguments{
\item{timeseries}{an object of class ts or mts}

\item{colname}{Column name to give to the time period column}
}
\value{
a data.frame with the same number of rows as the original time series
}
\description{
Convert a ts object to data.frame with columns for time period and the original data
}
\details{
A convenience function to create a data frame from a time series or
multiple time series object.  The motivation is to make it easy to pass time
series data to functions that need data frames such as ggplot2.
}
\examples{
head(tsdf(AirPassengers))

ld <- cbind(fdeaths, mdeaths)
head(tsdf(ld))
}

