% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chorological-maps.R
\name{fd_forest_chorological}
\alias{fd_forest_chorological}
\title{Download the Chorological Maps}
\usage{
fd_forest_chorological(species, range = "nat", quiet = FALSE)
}
\arguments{
\item{species}{a character vector with the Latin name of a tree species
contained in the Chorological Maps database (see details)}

\item{range}{the default "\code{nat}" downloads the probable native range
of the species, while "\code{syn}" downloads the synanthropic range
(i.e. the introduced and naturalized area and isolated population since Neolithic)}

\item{quiet}{if \code{TRUE}, suppress any message or progress bar}
}
\value{
\code{sf} object
}
\description{
Download the Chorological Maps for the main European Woody Species.
}
\details{
Data may be freely used for research, study, or teaching, but be cited
appropriately (see references below).

The chorological maps provide a general overview of the distribution of
the main European woody species. The geodatabase was formed by the
combination of numerous and heterogeneous data for a continental-scale
overview of the species' distribution range. There are a total of 4 versions
available, and the function will get the most recent version for each
of the species. This means for instance that some species may be on
version 2, and therefore, the data from that version will be retrieved.
}
\examples{
\donttest{
 # Download data for sweet chestnut
 chestnut_nat_sf <- fd_forest_chorological(species = "Castanea sativa", range = "nat")

 # Plot the data
 plot(chestnut_nat_sf$geometry)
 }
}
\references{
Caudullo, G., Welk, E., San-Miguel-Ayanz, J., 2017.
Chorological maps for the main European woody species. Data in Brief 12,
666. DOI: doi.org/10.1016/j.dib.2017.05.007
}
\seealso{
\link{metadata_forestdata} for a list of possible species
}
