use std::fs::File;
use std::io;

// test-data/plain.npy is generated by this Python code:
//
// import numpy as np
// a = np.array([1, 3.5, -6, 2.3])
// np.save('test-data/plain.npy', a)

fn main() -> Result<(), Box<dyn std::error::Error>> {
    let file = io::BufReader::new(File::open("test-data/plain.npy")?);

    let npy = npyz::NpyFile::new(file)?;
    for arr in npy.data::<f64>()? {
        eprintln!("{:?}", arr?);
    }
    Ok(())
}
