% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_karcher_cov.R
\name{multivariate_karcher_cov}
\alias{multivariate_karcher_cov}
\title{Curve Karcher Covariance}
\usage{
multivariate_karcher_cov(align_data)
}
\arguments{
\item{align_data}{fdacurve object from \link{multivariate_karcher_mean} of aligned data}
}
\value{
K covariance matrix
}
\description{
Calculate Karcher Covariance of a set of curves
}
\examples{
out <- multivariate_karcher_mean(beta[, , 1, 1:2], maxit = 2)
# note: use more shapes, small for speed
K <- multivariate_karcher_cov(out)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
